
=begin

Monmusu Quest! RPG
　System Save Fault Handling ver2  2015/03/26


用語
　システムデータ　　　　　　　SystemSave.rvdata2  SystemSave2.rvdata2
　　　　　　　　　　　　　　　　特定のタイミングでどちらか片方に保存
　バックアップシステムデータ　SystemSaveBackup.rvdata2
　　　　　　　　　　　　　　　　中身はシステムデータと同じ
　　　　　　　　　　　　　　　　システムセーブを一定回数すると保存

機能一覧　説明は下　このverで新規追加したものは●　変更したものは○
・システムデータファイルを２つにすることで初期化対策
・システムセーブのタイミングを変更
・システムセーブ失敗時、メッセージを表示
・システムロード失敗時、メッセージを表示して強制終了
・システムセーブのバックアップ間隔を変更

機能説明
・システムデータファイルを２つにすることで初期化対策
　SystemSave.rvdata2  SystemSave2.rvdata2  の２つ
　　セーブするのは「セーブ回数」が少ないファイル
　　ロードするのは「セーブ回数」が多いファイル
　セーブ失敗して片方が初期化されても、
　　ロードは「初期化されなかったほう」、セーブは「初期化されたほう」に行うので
　　両方のデータが完全に初期化されることは防がれる

・システムセーブのタイミングを変更
　「ゲーム終了時」の実行をなくし「シーン切り替え」のたびに実行するように
　シーン切り替えの例　マップ→メニュー　戦闘→図鑑　メニュー→セーブ

=end

module SaveSystemData
  
  # システムセーブ失敗時にメッセージボックスで表示されるメッセージ
  # 先頭に【システム】が入るので、冒頭は「セーブ」で
  FailureMes1 = [
    "Failed To Save",
    "Try Restarting the Game, Restarting PC may also help.",
    "",
    "PC might be the cause, if this continues try restarting.",
  ]
  
  # システムロード失敗時にメッセージボックスで表示されるメッセージ
  # 先頭に【システム】が入るので、冒頭は「ロード」で
  # 自動的にゲームが閉じるので、ゲームを閉じる指示は不要
  FailureMes2 = [
    "Failed To Load",
    "Try Restarting the Game, Restarting PC may also help.",
    "",
    "PC might be the cause, if this continues try restarting.",
  ]
  
  # バックアップシステムデータの保存間隔を変更　以前は3
  # セーブ時に「セーブ回数 ÷ この値」の余りが0ならばバックアップを作成する
  BackUpNum = 1
  
end

#==============================================================================
# ■ SaveSystemData
#==============================================================================
class << SaveSystemData
  #--------------------------------------------------------------------------
  # ● オートセーブ
  #--------------------------------------------------------------------------
  def auto_save
    DataManager.save_system
  end
  #--------------------------------------------------------------------------
  # ● ロードファイル名
  #--------------------------------------------------------------------------
  def load_filename
    r = filename_with_save_count.max_by {|name_count| name_count[1] }
    puts "★Run The System Load:#{r[0]}"
    return r[0]
  end
  #--------------------------------------------------------------------------
  # ● セーブファイル名
  #--------------------------------------------------------------------------
  def save_filename
    r = filename_with_save_count.min_by {|name_count| name_count[1] }
    puts "★Run The System Save:#{r[0]}"
    return r[0]
  end
  #--------------------------------------------------------------------------
  # ● ファイル名候補
  #--------------------------------------------------------------------------
  def filename_set
    return ["Save/SystemSave.rvdata2", "Save/SystemSave2.rvdata2"]
  end
  #--------------------------------------------------------------------------
  # ● ファイル名とセーブ回数を取得
  #--------------------------------------------------------------------------
  def filename_with_save_count
    name = filename_set
    count = []
    for i in 0..1
      begin
        File.open(name[i], "rb") do |file|
          count[i] = Marshal.load(file)[:system_save_count]
        end
      rescue
      end
      count[i] ||= -1
    end
    return name.zip(count)
  end
end

#==============================================================================
# ◆ Exit
#==============================================================================
module Exit
  # ---------------------------------------------------------------------------
  # ◆ カスタマイズポイント 解放処理を記述します。
  # ---------------------------------------------------------------------------
  def self.dispose
  end
end
